/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

/**************************************************************************
 *
 *	XVID MPEG-4 VIDEO CODEC
 *	8bit<->16bit transfer
 *
 *	This program is an implementation of a part of one or more MPEG-4
 *	Video tools as specified in ISO/IEC 14496-2 standard.  Those intending
 *	to use this software module in hardware or software products are
 *	advised that its use may infringe existing patents or copyrights, and
 *	any such use would be at such party's own risk.  The original
 *	developer of this software module and his/her company, and subsequent
 *	editors and their companies, will have no liability for use of this
 *	software or modifications or derivatives thereof.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *************************************************************************/

/**************************************************************************
 *
 *	History:
 *
 *	07.01.2002	merge functions from compensate; rename functions
 *	22.12.2001	transfer_8to8add16 limit fix
 *	07.11.2001	initial version; (c)2001 peter ross <pross@cs.rmit.edu.au>
 *
 *************************************************************************/

#include "global.h"
#include "mem_transfer.h"

#pragma DATA_SECTION(clip_table,"mem_transfer_clip_table_SECTION");
int     clip_table[1024];
int    *clp;

void
initialize_clip_table()
{
    int     i;
    clp = clip_table;
    clp += 384;
    for (i = -384; i < 640; i++)
        clp[i] = (i < 16) ? 16 : ((i > 235) ? 235 : i);
}

void
transfer8x8_copy(uint8 * dst, uint8 * src, const int stride,
                 const int dst_stride, const int nouse)
{
    memcpy(dst + 0 * dst_stride, src + 0 * stride, 8);  //2008/1/15 08:20pm
    memcpy(dst + 1 * dst_stride, src + 1 * stride, 8);
    memcpy(dst + 2 * dst_stride, src + 2 * stride, 8);
    memcpy(dst + 3 * dst_stride, src + 3 * stride, 8);
    memcpy(dst + 4 * dst_stride, src + 4 * stride, 8);
    memcpy(dst + 5 * dst_stride, src + 5 * stride, 8);
    memcpy(dst + 6 * dst_stride, src + 6 * stride, 8);
    memcpy(dst + 7 * dst_stride, src + 7 * stride, 8);
}

//following code is using clip table 2008/2/7 05:29pm
void
transfer_16to8copy(uint8 * const restrict dst, int16 * const restrict src,
                   xint stride)
{
    uint16  j;
    //int temp;
    for (j = 0; j < 8; j++)
    {
        dst[j * stride + 0] = clp[src[j * 8 + 0]];
        dst[j * stride + 1] = clp[src[j * 8 + 1]];
        dst[j * stride + 2] = clp[src[j * 8 + 2]];
        dst[j * stride + 3] = clp[src[j * 8 + 3]];
        dst[j * stride + 4] = clp[src[j * 8 + 4]];
        dst[j * stride + 5] = clp[src[j * 8 + 5]];
        dst[j * stride + 6] = clp[src[j * 8 + 6]];
        dst[j * stride + 7] = clp[src[j * 8 + 7]];
    }
}

void
transfer_16to8add(uint8 * const restrict dst, int16 * const restrict src,
                  xint stride)
{
    uint16  j;
    //int temp;

    for (j = 0; j < 8; j++)
    {
        dst[j * stride + 0] = clp[dst[j * stride + 0] + src[j * 8 + 0]];
        dst[j * stride + 1] = clp[dst[j * stride + 1] + src[j * 8 + 1]];
        dst[j * stride + 2] = clp[dst[j * stride + 2] + src[j * 8 + 2]];
        dst[j * stride + 3] = clp[dst[j * stride + 3] + src[j * 8 + 3]];
        dst[j * stride + 4] = clp[dst[j * stride + 4] + src[j * 8 + 4]];
        dst[j * stride + 5] = clp[dst[j * stride + 5] + src[j * 8 + 5]];
        dst[j * stride + 6] = clp[dst[j * stride + 6] + src[j * 8 + 6]];
        dst[j * stride + 7] = clp[dst[j * stride + 7] + src[j * 8 + 7]];
    }
}
